#include "..\..\DLL\d_iNES.h"

namespace {
uint8_t reg[2];

void sync (void) {
	if (reg[1] &0x10)
		EMU->SetPRG_ROM32(0x8, reg[1] >>6);
	else {
		EMU->SetPRG_ROM16(0x8, reg[1] >>5);
		EMU->SetPRG_ROM16(0xC, reg[1] >>5);
	}
	if (reg[0] &0x80)
		EMU->SetCHR_ROM8(0x0, reg[0] >>3 &0x08 | reg[1] &0x07);
	else
		EMU->SetCHR_ROM8(0x0, reg[0] >>3 &0x08 | reg[1] &0x04 | reg[0] &0x03);
	if (reg[1] &0x08)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}

int MAPINT readPad (int bank, int addr) {
	return ROM->dipValue;
}

void MAPINT writeReg (int bank, int addr, int val) {
	if (bank &2)
		reg[addr >>11] = reg[addr >>11] &~0x40 | val &0x40; // ABCARD-02/19
	else
		reg[addr >>11] = val; 
	sync();
}

void MAPINT reset (RESET_TYPE) {
	for (auto& c: reg) c = 0;
	sync();
	EMU->SetCPUReadHandler(0x5, readPad);
	EMU->SetCPUReadHandler(0x6, readPad);
	for (int bank = 0x8; bank <= 0xF; bank++) EMU->SetCPUWriteHandler(bank, writeReg);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	SAVELOAD_BYTE(stateMode, offset, data, reg[0]);
	SAVELOAD_BYTE(stateMode, offset, data, reg[1]);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 57;
} // namespace

MapperInfo MapperInfo_057 = {
	&mapperNum,
	_T("GK 6-in-1"),
	COMPAT_FULL,
	NULL,
	reset,
	NULL,
	NULL,
	NULL,
	saveLoad,
	NULL,
	NULL
};